@echo off
rem File:       AddEloCat.bat 
rem OS:         WinXp setup file for WinCE5.0 development
rem Purpose:    Adds or updates the EloTouch components in the Catalog (shared by 
rem all platforms). See RemEloCat.bat to remove EloTouch components from the 
rem Catalog.
rem Copyright:  2008 EloTouch Systems, Inc.
rem Updated:    2008-09-25
rem ........................... notes ..........................................
rem Platform Builder utility pbcec.exe must be in the current path. This is usually
rem C:\Program Files\Windows CE Platform Builder\5.00\CEPB\BIN\pbcec.exe. To make
rem sure of this, this file should be executed from a platform's release directory
rem environment.
rem ...................................................................
setlocal ENABLEEXTENSIONS ENABLEDELAYEDEXPANSION 

echo %0 adds/updates Elo TouchSystems components in the CE5.0 Catalog.

if "%_TGTPLAT%" == "" (
    echo FAIL: _TGTPLAT is undefined. Open a platform's Release Directory, come back
    echo to here, and try again.
    exit /B 1
)

rem Remove any previous elo catalog components
for %%p in (eloUsb,eloSer,eloApi,eloVa,eloTalk,eloBeep,eloCpl) do (
    pbcec -r -silent %%p.cec
)

rem Add the new current elo components
for %%p in (eloUsb,eloSer,eloApi,eloVa,eloTalk,eloBeep,eloCpl) do (
    pbcec %%p\%%p.cec
)

